%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Instituto Federal Sul-rio-grandense             
% Engenharia Elétrica                    
%---------------------------------------------------------------------------
% Definição do arquivo de classe eepfc.cls - Modelo de PFC - Engenharia Elétrica
%---------------------------------------------------------------------------
% Versão 20100631 - Baseada na classe ABNTex2 versão 1.8
%                                                           
% 2014 Cláudio Luís d'Elia Machado (claudiomachado@pelotas.ifsul.edu.br)
% 
% Baseado em ufscThesis.cls - arquivo de classe UFSCThesis - Modelo de Tese para a BU-UFSC
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Instituto Federal Sul-rio-grandense             
% Engenharia Elétrica                    
%---------------------------------------------------------------------------
% Definição do arquivo de estilo eepfc_estilo.sty - Modelo de PFC - Engenharia Elétrica
%---------------------------------------------------------------------------
% Versão 20100631 - Baseada na classe ABNTex2 versão 1.8
%                                                           
% 2014 Cláudio Luís d'Elia Machado (claudiomachado@pelotas.ifsul.edu.br)
% 
% Baseado no arquivo de estilo BUUFSCThesis - Modelo de Tese para a BU-UFSC
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Universidade Federal de Santa Catarina             
% Biblioteca Universitária                     
%---------------------------------------------------------------------------
% Definicao do arquivo de classe UFSCThesis - Modelo de Tese para a BU-UFSC
%---------------------------------------------------------------------------
% Versão 20100631 - Baseada na classe ABNTex versão 0.8-2
%                                                           
% (c)2010 Roberto Simoni (roberto.emc@gmail.com)
%         Carlos R Rocha (cticarlo@gmail.com)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%                                                         
% This file may be distributed and/or modified              
%
% 1. under the LaTeX Project Public License and/or          
% 2. under the GNU Public License.                          
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 

\NeedsTeXFormat{LaTeX2e}   % Identifica a versão de LaTeX em uso
\ProvidesClass{eepfc} % Informa o tipo de documentclasse que ele é


%---------------------------------------------------------------------------
% Passa as opções não interessantes para a classe base ABNTex2
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{abntex2}}
\ProcessOptions

%---------------------------------------------------------------------------
% Carrega classe ABNTex2, com padrão de página A4, fonte 12pt, frente e verso
\LoadClass[12pt,% tamanho da fonte
openright,% capítulos começam em pág ímpar (insere página vazia caso preciso)
% twoside,% para impressão em verso e anverso. Oposto a oneside
oneside,% para impressão em verso e anverso. Oposto a oneside
a4paper,% tamanho do papel. 
% -- opções da classe abntex2 --
%chapter=TITLE,% títulos de capítulos convertidos em letras maiúsculas
%section=TITLE,% títulos de seções convertidos em letras maiúsculas
%subsection=TITLE,% títulos de subseções convertidos em letras maiúsculas
%subsubsection=TITLE,% títulos de subsubseções convertidos em letras maiúsculas
%opções do pacote babel --
english,brazil]{abntex2}

% PACOTES
% Pacotes fundamentais 

% Definicao da geometria da página
\RequirePackage[a4paper,inner=3cm,outer=2cm,top=2.0cm,bottom=2cm,head=0.7cm,foot=0.7cm]{geometry}
% Se o cabecalho e o rodape estao dentro das margens, acrescentar as opcoes includehead e includefoot


% Obs: Suprimi o arquivo de estilo com objetivo de se utilizar apenas um arquivo de modelo e outro bibtex
% Pacote de definicoes do texto do PFC estilo Engenharia Elétrica IFSul-Pelotas
% \RequirePackage{ee_pfc/eepfc_estilo}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%                                                         
% Pacotes essenciais para o estilo funcionar
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
\usepackage{amsmath,amsfonts,amsthm,bm} %para usar negrito em letras em algumas gregas
\usepackage{lmodern} % Usa a fonte Latin Modern

\usepackage[T1]{fontenc} % Selecao de codigos de fonte.
\usepackage[utf8]{inputenc} % Codificacao do documento (conversão automática dos acentos)
\usepackage{lastpage} % Usado pela Ficha catalográfica
\usepackage{indentfirst} % Indenta o primeiro parágrafo de cada seção.
\usepackage{color} % Controle das cores
\usepackage{graphicx} % Inclusão de gráficos
\usepackage{wallpaper}
\usepackage{microtype} % para melhorias de justificação
\usepackage{subfig} %pacote para incluir figuras lado a lado
% Pacotes adicionais, usados apenas no âmbito do Modelo Canônico do abnteX2
\usepackage{lipsum} % para geração de dummy text
\usepackage{soul}
\usepackage{pdfpages}
\usepackage{gensymb}
% Pacotes de citações
\usepackage[english,hyperpageref]{backref}   % Paginas com as citações na bibl
\usepackage[alf]{abntex2cite}   % Citações padrão ABNT
\usepackage{tabu}
\usepackage{array}
% Definicao de espacamento simples
\RequirePackage{setspace}

% Definicao de espacamento simples
\RequirePackage{setspace}

% Configurações do pacote backref
% Usado sem a opção hyperpageref de backref
\renewcommand{\backrefpagesname}{Citado na(s) página(s):~}
% Texto padrão antes do número das páginas
\renewcommand{\backref}{}
% Define os textos da citação
\renewcommand*{\backrefalt}[4]{
\ifcase #1 %
Nenhuma citação no texto.%
\or
Citado na página #2.%
\else
Citado #1 vezes nas páginas #2.%
\fi}%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Configurações de aparência do PDF final
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% alterando o aspecto da cor azul
\definecolor{blue}{RGB}{41,5,195}

% informações do PDF
\makeatletter  % changes the catcode of @ to 11
\hypersetup{
%pagebackref=true,
pdftitle={\@title}, 
pdfauthor={\@author},
pdfsubject={\imprimirpreambulo},
pdfcreator={LaTeX with abnTeX2},
pdfkeywords={abnt}{latex}{abntex}{abntex2}{trabalho acadêmico}, 
colorlinks=false,% false: boxed links; true: colored links
%linkcolor=blue,% color of internal links
linkcolor=black,% color of internal links
%citecolor=blue,% color of links to bibliography
citecolor=black,% color of links to bibliography
filecolor=magenta,% color of file links
urlcolor=blue,
bookmarksdepth=4
}
\makeatother % changes the catcode of @ back to 12

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Espaçamentos entre linhas e parágrafos 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% O tamanho do parágrafo é dado por:
%\setlength{\parindent}{1.3cm}

% Controle do espaçamento entre um parágrafo e outro:
\setlength{\parskip}{0.2cm}  % tente também \onelineskip


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Definição de espaços na folha de aprovação
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Comando \assinatura for signature
   % width of the line and text under the line
\setlength{\ABNTEXsignwidth}{10cm}
   % thickness of the line
\setlength{\ABNTEXsignthickness}{1pt}
   % ammount of space left between previous text and th signature line
\setlength{\ABNTEXsignskip}{0.5cm}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Impressão da Capa
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\renewcommand{\imprimircapa}{%
\begin{capa}%
\ThisCenterWallPaper{0.9}{figs/ifsul_capa.jpg}
\center
\vspace*{4cm}
\makebox[\textwidth][r]{\bfseries{\textbf{Curso de Engenharia Elétrica}}\hspace{2cm}}
\makebox[\textwidth][r]{\bfseries{\textbf{Monografia do Projeto de Fim de Curso}}\hspace{2cm}}\vspace*{2cm}

\makebox[\textwidth][r]{
\begin{minipage}[t]{0.8\textwidth}
\begin{flushright}
\ABNTEXchapterfont\bfseries\imprimirtitulo
\end{flushright}
\end{minipage}\hspace{2cm}}
\\ \vspace*{2cm}

%\vspace*{\fill}
%\makebox[\textwidth][r]{\ABNTEXchapterfont\bfseries\Large\imprimirtitulo\hspace{2cm}}\vspace*{2cm}
\makebox[\textwidth][r]{\ABNTEXchapterfont\bfseries\large\imprimirautor\hspace{2cm}}\vspace{2cm}
% \vfill
% \makebox[\textwidth][c]{\large\textbf{\imprimirlocal}}\vspace*{0.3cm}
\makebox[\textwidth][r]{\bfseries\large{\imprimirdata}\hspace{2cm}}
\end{capa}
}



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Folha de rosto
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
%   usar \imprimirfolhaderosto* casodeseje imprimir algo no verso da
%   página no caso de estar no modo twoside. Util para imprimir a Ficha
%   Bibliografica. Porem, se estiver no modo oneside, a versao sem estrela
%   é identica.
\renewenvironment{folhaderosto}[1][\folhaderostoname]{\clearpage\PRIVATEbookmarkthis{#1}}{\cleardoublepage}
\renewenvironment{folhaderosto*}[1][\folhaderostoname]{\clearpage\PRIVATEbookmarkthis{#1}}{\newpage}%

% ---
% Conteudo padrao da Folha de Rosto
\makeatletter
\renewcommand{\folhaderostocontent}{
  \begin{center}
    %{\abntex@ifnotempty{\imprimirinstituicao}{\imprimirinstituicao\vspace*{\fill}}}
\normalsize{
\bfseries{Instituto Federal de Educação, Ciência e Tecnologia Sul-rio-grandense}
\par
\bfseries{Departamento de Ensino de Graduação e Pós-Graduação}
\par
\bfseries{Campus Pelotas}
\par
\bfseries{Curso de Engenharia Elétrica}
}   

\vspace*{3cm}
{\ABNTEXchapterfont\bfseries{\imprimirautor}}

\vspace*{2cm}
{\bfseries\imprimirorientadorRotulo~\imprimirorientador\par}
\abntex@ifnotempty{\imprimircoorientador}{%
{\bfseries\imprimircoorientadorRotulo~\imprimircoorientador}%
}%
\vspace*{3cm}

\begin{center}
\ABNTEXchapterfont\bfseries\imprimirtitulo
\end{center}
\vspace*{\fill}


{\ABNTEXchapterfont\textbf{Monografia do Projeto de Fim de Curso}}
\vspace*{\fill}

% \abntex@ifnotempty{\imprimirpreambulo}{%
% \hspace{.45\textwidth}
% \begin{minipage}{.5\textwidth}
% \SingleSpacing
% \imprimirpreambulo
% \end{minipage}%
% \vspace*{\fill}
% }%

{\bfseries\imprimirlocal}
\par
{\bfseries\imprimirdata}
\vspace*{1cm}
\end{center}
}
\makeatother

\renewcommand{\imprimirfolhaderostostar}[1]{%
  \begin{folhaderosto*}{#1}
     \folhaderostocontent
  \end{folhaderosto*}}

\renewcommand{\imprimirfolhaderostonostar}[1]{%
  \begin{folhaderosto}{#1}
     \folhaderostocontent
  \end{folhaderosto}}

\makeatletter
\renewcommand{\imprimirfolhaderosto}[1][\folhaderostoname]{%
   \@ifstar
     \imprimirfolhaderostostar  
     \imprimirfolhaderostonostar
}
\makeatother
% ---


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Ambiente para definicao Cessão de Direitos
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newenvironment{cessaodedireitos}{\begin{titlingpage}}{\end{titlingpage}\cleardoublepage}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Lista de figuras
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\AtBeginDocument{\renewcommand{\listfigurename}{Lista de figuras}}



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Substituição e criação de comandos relacionados com capítulos e seções
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\renewcommand{\ABNTEXchapterfont}{\fontfamily{cmr}\fontseries{b}\selectfont}
\renewcommand{\ABNTEXchapterfontsize}{\Large}
\renewcommand{\ABNTEXsectionfontsize}{\large}



\renewcommand{\ABNTEXchapterfont}{\fontfamily{cmr}\fontseries{b}\selectfont}
\renewcommand{\ABNTEXchapterfontsize}{\Large}
\renewcommand{\ABNTEXsectionfontsize}{\large}

% Removendo as caixas na volta de links
\hypersetup{pdfborder=0 0 0}


\DeclareMathOperator{\sen}{sen}